<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/*
 * Created on 26. Feb. 2007 by Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 */

/**
 * TextFragment class file.
 * 
 * PHP versions 5
 *   
 * LICENSE:
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many individuals
 * and is licensed under the GPL. For more information please see
 * <http://opendocumentphp.org>.
 * 
 * $Id: TextFragment.php 249 2007-07-31 08:36:12Z nmarkgraf $
 * 
 * @category    File Formats
 * @package     OpenDocumentPHP
 * @subpackage  content_body_text
 * @author      Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 * @copyright   Copyright in 2006, 2007 by The OpenDocumentPHP Team 
 * @license     http://www.gnu.org/licenses/gpl.html GNU General Public License 2.0.
 * @version     SVN: $Id: TextFragment.php 249 2007-07-31 08:36:12Z nmarkgraf $
 * @link        http://opendocumentphp.org
 * @since       0.5.2 - 26. Feb. 2007
 */

/**
 * 
 */
require_once 'OpenDocumentPHP/content/body/text/Heading.php';
require_once 'OpenDocumentPHP/content/body/text/Paragraph.php';
require_once 'OpenDocumentPHP/content/body/text/UserFieldDecl.php';
require_once 'OpenDocumentPHP/content/body/text/UserFieldGet.php';
require_once 'OpenDocumentPHP/content/body/text/UserFieldDecls.php';
require_once 'OpenDocumentPHP/util/ODPElement.php';

/**
 * TextFragment class.
 * 
 * Here we store the <office:text>...<office:text> part of the content tree.
 *  
 * @category    File Formats
 * @package     OpenDocumentPHP
 * @subpackage  content_body_text
 * @author      Norman Markgraf (nmarkgraf(at)user.sourceforge.net)
 * @copyright   Copyright in 2006, 2007 by The OpenDocumentPHP Team 
 * @license     http://www.gnu.org/licenses/gpl.html GNU General Public License 2.0.
 * @version     Release: @package_version@
 * @link        http://opendocumentphp.org
 * @since 		0.5.2 - 26. Feb. 2007
 */
class TextFragment extends ODPElement {

    /**
     * @access      private
     */
	private $forms = null;

    /**
     * @access      private 
     */
	private $sequenzDecl = null;

    /**
     * @access      private
     */
	private $userFieldDecl = null;
	
	/**
	 * Constructor method.
	 * 
	 * @since 		0.5.2 - 26. Feb. 2007
     */
    function __construct($elem=null) 
    {         
        if (is_null($elem)) {
           parent::__construct('office:text', '', self::OFFICE);
        } else {
           parent::__construct($elem);         
        }	
	}
	
	/**
	 * Create a new paragraph and append it to the document.
	 * 
	 * @access 		public
	 * @since 		0.5.2 - 26. Feb. 2007
	 */
	function nextParagraph() 
	{
		$par = new Paragraph();
		$this->appendChild($par);
		return $par;
	}
	
	/**
	 * Create a new heading and append it to the document.
	 * 
	 * @param		int $outlineLevel  Outline level of this heading.
	 * @access 		public
	 * @since 		0.5.2 - 26. Feb. 2007
	 */
	function nextHeading($outlineLevel = 1) 
	{
		$par = new Heading();
        $this->appendChild($par->getElement());		
		$par->setHeadingLevel($outlineLevel);
		return $par;
	}
	
	/**
	 * Update User Field Decl(aration) 
	 * 
	 * @param		string $name  The name of the user-field-decl(aration) to be updated.
	 * @param		string $value The new value.
	 * @access 		public
	 * @since 		0.5.2 - 26. Feb. 2007
	 */	
	function updateUserFieldDecl($name, $value) 
	{
		if (is_null($this->userFieldDecl)) {
			$node = $this->getTag('/office:document-content/office:body/office:text/text:user-field-decls', '', '', -1);
			if ($node == '') {
				$this->userFieldDecl = new UserFieldDecls();				
			} else {
				$this->userFieldDecl = new UserFieldDecls($node);
			}
		}
		$this->userFieldDecl->setUserFieldDecl($name, $value);
		// *** FIX ME ***
		// We must now scan the document for <text:user-field-get> tags and update them!
		$this->initXpath();
		$result = $this->xpath->query('/*/text:user-field-get[@name="' . $name . '"]');
		foreach ($result as $node) {
			$ufd = new UserFieldGet($node);
			$ufd->updateValue($value);
		}
	}
}
?>
